!function($,undefined){"use strict";var _window=window,_document=document,_body=_document.body;var abs=Math.abs,max=Math.max,min=Math.min,floor=Math.floor,round=Math.round;_window.$us=_window.$us||{};_window.$ush=_window.$ush||{};const _DIRECTION_={DOWN:'down',RIGHT:'right',};const _TRANSLATE_FACTOR_=7;function scroll(){return{top:_window.scrollY||_window.pageYOffset,left:_window.scrollX||_window.pageXOffset}}
function isDisableEffects(){return $us.canvasOptions.disableEffectsWidth>=_body.clientWidth}
var _$temp={bodyHeight:$ush.parseInt(_body.clientHeight),disableEffects:isDisableEffects(),};function ScrollEffects(){var self=this;self.elms=[];self._events={scroll:self._handleScroll.bind(self),resize:$ush.debounce(self._handleResize.bind(self),25),updateElmsInitialData:$ush.debounce(self._handleUpdateElmsInitialData.bind(self),1),};$us.$window.on('scroll',self._events.scroll).on('resize',self._events.resize);$us.$canvas.on('contentChange',self._events.updateElmsInitialData)}
ScrollEffects.prototype={addElms:function(elms){var self=this;if(!$.isArray(elms)){elms=[elms]}
elms.map(function(element){if($ush.isNode(element)){for(var i in self.elms){if(self.elms[i].node===element){self.elms[i].removeEffects();self.elms.splice(i,1);break}}
self.elms.push(new SE_Manager(element))}})},_handleUpdateElmsInitialData:function(){var self=this;self.elms.map(function(element){element.setInitialData()})},_handleResize:function(){var self=this;var disableEffects=isDisableEffects();if(_$temp.disableEffects!==disableEffects){_$temp.disableEffects=disableEffects;self.elms.map(function(element){element[disableEffects?'removeEffects':'applyEffects']()})}
var bodyHeight=$ush.parseInt(_body.clientHeight);if(_$temp.bodyHeight===bodyHeight){return}
_$temp.bodyHeight=bodyHeight;self._handleUpdateElmsInitialData()},_handleScroll:function(){var self=this;if(isDisableEffects()){return}
self.elms.map(function(element){if(!element.isInViewport()){element.node.classList.remove('in_viewport');return}
element.node.classList.add('in_viewport');element.applyEffects()})}};$us.scrollEffects=new ScrollEffects;function SE_Manager(node){var self=this;self.node=node;self.offsetTop=-0;self.nearestTop=-0;self.currentHeight=-0;self.initialData={top:-0,height:-0,};self._config={start_position:'0%',end_position:'100%',from_initial_position:0,translate_y:0,translate_y_direction:'up',translate_y_speed:'0.5x',translate_x:0,translate_x_direction:'left',translate_x_speed:'0.5x',opacity:0,opacity_direction:'out-in',scale:0,scale_direction:'up',scale_speed:'0.5x',delay:'0.1s',};var $node=$(node);$.extend(self._config,$node.data('us-scroll')||{});self.setInitialData();node.classList.toggle('in_viewport',self.isInViewport());if(!isDisableEffects()){self.applyEffects()}
$ush.timeout(function(){node.style.setProperty('--scroll-delay',self.getParam('delay'))},100)}
SE_Manager.prototype={setInitialData:function(){var self=this,rect=$ush.$rect(self.node);self.currentHeight=rect.height;self.initialData.height=rect.height;self.initialData.top=scroll().top+rect.top-$ush.parseFloat(self.style('--translateY'))},isInViewport:function(){var self=this,rect=$ush.$rect(self.node),initialTop=self.initialData.top-scroll().top,nearestTop=min(initialTop,rect.top)-_window.innerHeight;self.offsetTop=rect.top;self.nearestTop=nearestTop;self.currentHeight=rect.height;return(nearestTop<=0&&(max(initialTop,rect.top)+rect.height)>=0)},hasClass:function(className){return className&&this.node.classList.contains(className)},style:function(prop,value){var elmStyle=this.node.style;if($ush.isUndefined(value)){return elmStyle.getPropertyValue(prop)}else{elmStyle.setProperty(prop,$ush.toString(value))}},getParam:function(name,defaultValue){var self=this;return(self.node.dataset[name]||self._config[name]||defaultValue)},getPositionData:function(offsetY,distanceInPx){var self=this,currentPosition=100-($ush.parseFloat(offsetY)/$ush.parseFloat(distanceInPx)*100),startPosition=$ush.parseInt(self.getParam('start_position')),endPosition=$ush.parseInt(self.getParam('end_position'));return{start:startPosition,current:$ush.limitValueByRange(currentPosition,0,100),end:endPosition,diff:(endPosition-startPosition),}},getTranslate:function(offsetY,distance,translateSpeed){var self=this,position=self.getPositionData(offsetY,distance),currentPosition=position.current;if($ush.parseInt(self.getParam('from_initial_position'))==1){return(scroll().top/_window.innerHeight*100)*_TRANSLATE_FACTOR_*translateSpeed}else{if(position.start&&floor(currentPosition)<=position.start){currentPosition=position.start}
if(position.end&&floor(currentPosition)>=position.end){currentPosition=position.end}
return(currentPosition-50)*_TRANSLATE_FACTOR_*translateSpeed}},applyEffects:function(){var self=this;self.setTranslateY();self.setTranslateX();self.setOpacity();self.setScale()},removeEffects:function(){var self=this;['--translateY','--translateX','--opacity','--scale'].map(function(varName){self.style(varName,'')})},setTranslateY:function(){var self=this;var translateSpeed=$ush.parseFloat(self.getParam('translate_y_speed'));if(!self.hasClass('has_translate_y')||!translateSpeed){return}
if(self.getParam('translate_y_direction')!==_DIRECTION_.DOWN){translateSpeed=-translateSpeed}
var elmHeight=self.initialData.height,translateY=self.getTranslate(self.offsetTop+elmHeight,_window.innerHeight+elmHeight,translateSpeed);self.style('--translateY',translateY+'px')},setTranslateX:function(){var self=this;var translateSpeed=$ush.parseFloat(self.getParam('translate_x_speed'));if(!self.hasClass('has_translate_x')||!translateSpeed){return}
if(self.getParam('translate_x_direction')!==_DIRECTION_.RIGHT){translateSpeed=-translateSpeed}
var elmHeight=self.initialData.height,translateX=self.getTranslate(self.offsetTop+elmHeight,_window.innerHeight+elmHeight,translateSpeed);self.style('--translateX',translateX+'px')},setOpacity:function(){var self=this;var opacityDirection=self.getParam('opacity_direction'),opacity;if(!self.hasClass('has_opacity')||!opacityDirection){return}
if($ush.parseInt(self.getParam('from_initial_position'))==1){var initialPosition=$ush.parseInt(self.initialData.top+self.initialData.height/2);opacity=min(1,scroll().top/initialPosition)}else{var elmHeight=self.initialData.height,viewportHeight=_window.innerHeight,offsetTop=viewportHeight+self.nearestTop+elmHeight,position=self.getPositionData(offsetTop,viewportHeight+elmHeight),startPosition=position.start,currentPosition=$ush.limitValueByRange(round(position.current),startPosition,position.end);opacity=((100/position.diff)*(currentPosition-startPosition))/100}
if(opacityDirection==='in-out'){opacity=1-opacity}else if(opacityDirection==='in-out-in'){opacity=(2*opacity)-1}else if(opacityDirection==='out-in-out'){opacity=(opacity>0.5?2:0)-(2*opacity)}
self.style('--opacity',$ush.limitValueByRange(abs(opacity).toFixed(3),0,1))},setScale:function(){var self=this;var scaleSpeed=$ush.parseFloat(self.getParam('scale_speed'));if(!self.hasClass('has_scale')||!scaleSpeed){return}
if(self.getParam('scale_direction')===_DIRECTION_.DOWN){scaleSpeed=-scaleSpeed}
if($ush.parseInt(self.getParam('from_initial_position'))==1){var scale=1+(scroll().top/_window.innerHeight*100)/50*scaleSpeed}else{var elmHeight=max(self.initialData.height,self.currentHeight),viewportHeight=_window.innerHeight,offsetTop=viewportHeight+self.nearestTop+elmHeight,position=self.getPositionData(offsetTop,viewportHeight+elmHeight),currentPosition=$ush.limitValueByRange(round(position.current),position.start,position.end);var scale=1-(50-currentPosition)/50*scaleSpeed}
if(scale<0){scale=0}
self.style('--scale',scale)}};$.fn.usScrollEffects=function(){return this.each(function(){$us.scrollEffects.addElms(this)})};$(function(){$('[data-us-scroll]').usScrollEffects()})}(jQuery)